import matplotlib.pyplot as plt
import matplotlib
from matplotlib import font_manager

import numpy as np

import winpct.winpct

if __name__ == '__main__':
	#matplotlib.font_manager.fontManager.addfont("/Users/petrichor/Library/Fonts/seguiemj.ttf")
	# fpaths = matplotlib.font_manager.findSystemFonts()
	# for i in fpaths:
	# 	try:
	# 		f = matplotlib.font_manager.get_font(i)
	# 		print(f.family_name, i)
	# 	except:
	# 		pass

	gwp = winpct.winpct.GameWinPercent("68b36654c7846060e4d411bb")
	gwp = winpct.winpct.GameWinPercent("690cfe960d411ebcb8db11c6")
	gwp = winpct.winpct.GameWinPercent("690e33ef0d411ebcb8db298a")

	arr = []
	alpha = 1
	#print(matplotlib.rcParams["font.size"])

	xticks = [0]
	xtickslabels = ["t1"]
	yticks = [0,50,100]
	ytickslabels = [u"🗿","50",u"🍐"]
	bot = False
	inning = 9
	for index, ev in enumerate(gwp.event_list_wpa):
		#print(ev)
		if ev.event.homeatbat != bot:
			if ev.event.inning > inning:
				inning = ev.event.inning
			xticks.append(index)
			xtickslabels.append(f"{"b" if ev.event.homeatbat else "t"}{ev.event.inning}")
			bot = ev.event.homeatbat
		arr.append(ev.wp*100)
	np_arr = np.array(arr)

	#plt.figure(figsize=[1+inning,6.18])
	plt.figure(figsize=[inning,5.56], dpi=125)
	plt.grid(axis="y",c="black", dashes=(3,2))

	y1 = [50] * len(arr)
	# Create a visualization
	#plt.plot(np_arr)
	plt.xlim(0, len(arr)-1)
	plt.ylim(0, 100)
	plt.xticks(xticks, xtickslabels, fontsize=14)
	plt.yticks(yticks, ytickslabels, family=['Segoe UI Emoji','DejaVu Sans'], fontsize=20)

	#away
	plt.fill_between(range(len(arr)), 100, arr, color='#025196', alpha=alpha, aa=True)
	#home
	plt.fill_between(range(len(arr)), 0, arr, color="#fdb138", alpha=alpha, aa=True)
	#plt.subplots_adjust(left=0.05, right=.95, bottom=0.05, top=.97)
	plt.tight_layout()

	# Save the figure
	plt.savefig("seaborb2.png")
	plt.show()



