import asyncio
import random

import emoji
import discord

import data

PARTY_COLOR = "#7AFFF4"
EJECT_COLOR = "#1E3A8A"
WITHER_COLOR = "#8B0000"

async def wither_tracker(game_id: str, channel: discord.TextChannel, delay: int):
	state = "Initializing"
	index = 0
	short_name = "🐝 @ 🌦️"
	outage = 0
	game_json = data.MMOLBApiary.get_game_json(game_id)
	if game_json is not None:
		if game_json["Weather"]["Emoji"] == emoji.emojize(":partying_face:"):
			game_json["Weather"]["Emoji"] = emoji.emojize(":party_popper:")
		print(f"Weather tracking: {game_json["Weather"]["Emoji"]} {game_json['AwayTeamName']} @ {game_json['HomeTeamName']}")
		await asyncio.sleep(delay)
		print(f"Delay complete: {game_json["Weather"]["Emoji"]} {game_json['AwayTeamName']} @ {game_json['HomeTeamName']}")
		short_name = f"{game_json['AwayTeamEmoji']} @ {game_json['HomeTeamEmoji']}"
	while state != "Complete":
		game_json = data.MMOLBApiary.get_game_json(game_id)
		if game_json is None:
			outage += 1
			if outage >= 10:
				break
			await channel.send(content="<:outage:1429602929941418158>")
		if game_json is not None:
			if game_json["Weather"]["Emoji"] == emoji.emojize(":partying_face:"):
				game_json["Weather"]["Emoji"] = emoji.emojize(":party_popper:")
			outage = 0
			event_log = game_json["EventLog"]
			new_index = len(event_log)
			print(f"{short_name}: {state} {index} {new_index}")
			for i in event_log[index:]:
				#home run
				#todo: check if team is ours?
				if "home_run_distance" in i:
					title = generate_title(event_log[i["index"]-1], game_json["AwayTeamAbbreviation"], game_json["HomeTeamAbbreviation"])
					auth_icon = generate_runners(event_log[i["index"]-1])
					if i["inning_side"] == 0:
						color = "#" + game_json["AwayTeamColor"]
						player_emoji = game_json["AwayTeamEmoji"]
					else:
						color = "#" + game_json["HomeTeamColor"]
						player_emoji = game_json["HomeTeamEmoji"]
					msg = i['message'].replace("<strong>", "").replace("</strong>", "")
					distance = f"Distance: {i['home_run_distance']} ft."
					embed = generic_embed(msg, title, game_id, i['index'],color, desc=distance, auth_icon=auth_icon)
					await channel.send(embed=embed, content=f"{player_emoji} home run test 2. awawa.")
				# Party
				if i['event'] == "Party":
					title = generate_title(event_log[i["index"]], game_json["AwayTeamAbbreviation"],
										   game_json["HomeTeamAbbreviation"])
					auth_icon = generate_runners(event_log[i["index"]])
					msg = emoji.replace_emoji(i["message"], emoji.emojize(":party_popper:")).replace("<strong>","").replace("</strong>","")
					embed = generic_embed(msg, title, game_id, i['index'],PARTY_COLOR, auth_icon=auth_icon)
					await channel.send(embed=embed, content=emoji.emojize(":party_popper:"))
				# Wither
				if i['event'] == "Weather_Wither":
					desc = None
					title = generate_title(event_log[i["index"]], game_json["AwayTeamAbbreviation"],
										   game_json["HomeTeamAbbreviation"])
					auth_icon = generate_runners(event_log[i["index"]])
					message = f"{i['message']}"
					if "Corrupted" in message and random.randint(0,7) == 0:
						first_emoji = i['message'].split()[0]
						if first_emoji == game_json["AwayTeamEmoji"]:
							second_emoji = game_json["HomeTeamEmoji"]
						else:
							second_emoji = game_json["AwayTeamEmoji"]
						pitcher_name = i['pitcher']['name']
						batter_name = i['batter']['name']

						if pitcher_name in i['message']:
							first_name = f"{first_emoji} {pitcher_name}"
							second_name = f"{second_emoji} {batter_name}"
						else:
							first_name = f"{first_emoji} {batter_name}"
							second_name = f"{second_emoji} {pitcher_name}"

						message = f"{first_name} and {second_name} made out #sloppy style"
					if "Contained" in message:
						resisted_emoji = i['message'].split()[0]
						if resisted_emoji == game_json["AwayTeamEmoji"]:
							desc = f"{game_json["HomeTeamEmoji"]}{emoji.emojize(":arrow_heading_down:")}{emoji.emojize(":hole:")}"
						else:
							desc = f"{game_json["AwayTeamEmoji"]}{emoji.emojize(":arrow_heading_down:")}{emoji.emojize(":hole:")}"

					embed = generic_embed(message, title, game_id, i['index'], WITHER_COLOR, desc=desc, auth_icon=auth_icon)
					await channel.send(embed=embed, content=emoji.emojize(":wilted_rose:"))
				# Magnetic Storms
				elif "ejected" in i['message']:
					title = generate_title(event_log[i["index"]], game_json["AwayTeamAbbreviation"],
										   game_json["HomeTeamAbbreviation"])
					auth_icon = generate_runners(event_log[i["index"]])
					msg = i['message']
					msg_out =  msg[msg.index(emoji.emojize(":robot:")):]
					msg_spl = i['message'].split()
					ej_emoji = msg_spl[msg_spl.index("ejected")+1]
					desc = (f"<:nothing:1407773446540099704>{ej_emoji}<:nothing:1407773446540099704>\n"
							f"{emoji.emojize(":golf:")}<:nothing:1407773446540099704>{emoji.emojize(':person_golfing:')}")
					embed = generic_embed(msg_out, title, game_id, i['index'], EJECT_COLOR, desc=desc, auth_icon=auth_icon)
					#embed = eject_embed(msg_out, title, ej_emoji, game_id, i['index'])
					await channel.send(embed=embed, content=emoji.emojize(":person_golfing:"))
				# Efflorescence
				elif emoji.emojize(":rose:") in i['message']:
					title = generate_title(event_log[i["index"]], game_json["AwayTeamAbbreviation"],
										   game_json["HomeTeamAbbreviation"])
					auth_icon = generate_runners(event_log[i["index"]])
					msg = i['message']
					msg_out = msg[msg.index(emoji.emojize(":rose:")):]
					embed = generic_embed(msg_out, title, game_id, i['index'], "#8b0000", auth_icon=auth_icon)
					await channel.send(embed=embed, content=emoji.emojize(":rose:"))

			state = game_json["State"]
			index = new_index
		await asyncio.sleep(30)
		#await asyncio.sleep(60*5)
	print(f"{game_json["Weather"]["Emoji"]} {game_json['AwayTeamName']} @ {game_json['HomeTeamName']} done :)")

def generic_embed(embed_message: str, title: str, game_id: str, index: int, color: str,
				  desc: str | None = None, auth_icon: str | None = None) -> discord.Embed:
	embed = discord.Embed(title=embed_message,
						  description=desc,
						  color=discord.Color.from_str(color))
	embed.set_author(name=title, url=f"{data.MMOLBApiary.URL_NONAPI}watch/{game_id}?event={index}", icon_url=auth_icon)
	return embed

def generate_title(event: dict, away_team: str, home_team: str) -> str:
	return(f"{away_team} {event["away_score"]} - {event['home_score']} {home_team} - "
		   f"{"Top" if event["inning_side"] == 0 else "Bot"} {event['inning']}, "
		   f"{event["outs"] if event["outs"] is not None else "Three?"} {"Out" if event["outs"] == 1 else "Outs"}")

def generate_runners(event: dict) -> str:
	num = (event["on_1b"] * 1) + (event["on_2b"] * 2) + (event["on_3b"] * 4)
	return f"https://images.swarm.computer/mmolbee/bases/{num:03b}.png"

def make_ordinal(n):
	'''
	Convert an integer into its ordinal representation::
		make_ordinal(0)   => '0th'
		make_ordinal(3)   => '3rd'
		make_ordinal(122) => '122nd'
		make_ordinal(213) => '213th'
	'''
	n = int(n)
	if 11 <= (n % 100) <= 13:
		suffix = 'th'
	else:
		suffix = ['th', 'st', 'nd', 'rd', 'th'][min(n % 10, 4)]
	return str(n) + suffix

test_count = 0
def test_data():
	data = None
	match test_count:
		case 0:
			print(data)
		case 1:
			print(data)
		case 2:
			print(data)

if __name__ == "__main__":
	print("gooper")
