import asyncio
import random

from discord.ext import tasks

import corruption
import data
import times
import views
import stats
import winpct.flavor as flavor
import discord
from discord import app_commands

from data import Game
from stats import Statistics
from winpct.winpct import GameWinPercent, Palette

TOKEN = ''
TEMP = discord.Object(id=1387475603741212932)

class MMOLBee(discord.Client):

	def __init__(self, *, intents: discord.Intents):
		super().__init__(intents=intents)
		self.tree = app_commands.CommandTree(self)
		self.time = data.SeasonTime()
		self.kround = (0,0,0)

	async def setup_hook(self):
		self.tree.copy_global_to(guild=TEMP)
		await self.tree.sync()
		data.unserialize()
		check_games_tasks.start(self)
		# pissyshitties.start(self)
		update_standings.start(self)
		#disabled since stats aren't right currently
		#post_stats.start(self)
		season_weather.start(self)


mmolbee = MMOLBee(intents=discord.Intents.default())

async def league_autocomplete(
	interaction: discord.Interaction,
	current: str,
) -> list[app_commands.Choice[str]]:
	leagues = data.autocomplete
	return [app_commands.Choice(name=league, value=league)
		for league in leagues if current.lower() in league.lower()]

async def league_autocomplete_all(
	interaction: discord.Interaction,
	current: str,
) -> list[app_commands.Choice[str]]:
	leagues = data.autocomplete.copy()
	leagues.insert(0, "All")
	return [app_commands.Choice(name=league, value=league)
		for league in leagues if current.lower() in league.lower()]


async def stats_autocomplete(
		interaction: discord.Interaction,
		current: str,
) -> list[app_commands.Choice[str]]:

	#type B
	statlist = stats.Statistics
	out = [
		app_commands.Choice(name=f"{stat} - {statlist[stat].name}", value=stat)
		for stat in statlist.keys() if current.lower() in stat.lower()]
	if len(out) > 25:
		out.insert(0, app_commands.Choice(
			name="Discord only lets me show 25 options here - select this option to see them all", value="help"))
	return out[:25]


@mmolbee.tree.command(name="addteam", description="Add a team to a league")
@app_commands.autocomplete(league=league_autocomplete)
async def add_team_command(interaction: discord.Interaction, league:str):
	league = league.lower()
	if len(data.leagues) == 0:
		await interaction.response.send_message("No existing leagues yet!")
	elif league not in data.leagues:
		await interaction.response.send_message("Gonna have to pick an existing league, boss.")
	else:
		await interaction.response.send_modal(views.NewTeamModal(league))

@mmolbee.tree.command(name="addleague", description="Add a league")
async def add_league_command(interaction: discord.Interaction):
	await interaction.response.send_modal(views.NewLeagueModal())

@mmolbee.tree.command(name="refresh", description="Reloads team info")
async def unserialize_command(interaction: discord.Interaction):
	data.leagues = {}
	data.unserialize()

@mmolbee.tree.command(name="stats", description="Display league leaders")
@app_commands.autocomplete(stat=stats_autocomplete, league=league_autocomplete_all)
async def statistics_command(interaction: discord.Interaction, stat:str, league:str = None, ephemeral:bool = False): #all:bool = False):
	players = []
	if league is None:
		for leagueobj in data.leagues.values():
			if interaction.channel.id == leagueobj.channel:
				league = leagueobj.name.lower()
	else:
		league = league.lower()
	stat = stat.upper()
	if stat == 'HELP':
		out =""
		for i in stats.Statistics:
			out += f"{i}: {Statistics[i].name}\n"
		embed = discord.Embed(title="HELP",description=out)
		await interaction.response.send_message(embed=embed, ephemeral=True)
		return
	else:
		name = ""
		if league == "all":
			name = "🐝 MMOL-Bee"
			for leagueobj in data.leagues.values():
				for team in leagueobj.teams.values():
					players += team.players
		elif league not in data.leagues.keys():
			await interaction.response.send_message("The league doesn't exist.", ephemeral=True)
			return
		else:
			leagueobj = data.leagues[league]
			name = str(leagueobj)
			for team in leagueobj.teams.values():
				players += team.players

		statlist = stats.Statistics[stat].calc_leaderboard(players)
		embed = generate_stat_embed(statlist, name, stats.Statistics[stat].name)
		await interaction.response.send_message(embed=embed, ephemeral=ephemeral)

@mmolbee.tree.command(name="standings", description="Display league standings")
@app_commands.autocomplete(league=league_autocomplete)
async def league_teams_command(interaction: discord.Interaction, league:str, ephemeral:bool = False):
	league = league.lower()
	if league not in data.leagues.keys():
		await interaction.response.send_message("The league doesn't exist.")
	else:
		title = f'{data.leagues[league].emoji} {data.leagues[league].name} League Standings'
		standings = data.leagues[league].standings()
		list1 = []
		list2 = []
		list3 = []
		for team in standings:
			list1.append(f'{team.emoji} [{team.location} {team.name}](https://mmolb.com/team/{team.id})')
			list2.append(f'<:nothing:1407773446540099704>{team.wins()}-{team.losses()}')
			list3.append(f'-# ({team.winpct():0.3f}, {team.rundiff()})<:nothing:1407773446540099704>')

		embed = discord.Embed(color=discord.Color.from_str("#"+standings[0].color), title= title)
		embed.add_field(name="",value= "\n".join(list1), inline=True)
		embed.add_field(name="",value= "\n".join(list2), inline=True)
		embed.add_field(name="",value= "\n".join(list3), inline=True)
		await interaction.response.send_message(embed=embed, ephemeral=ephemeral)

@mmolbee.tree.command(name="weather", description="didn't you hear the news today?")
async def weather_command(interaction: discord.Interaction, ephemeral:bool = True):
	fo = data.Forecast()
	resp = await interaction.response.send_message(embed=fo.generate_embed(), ephemeral=ephemeral)


@mmolbee.tree.command(name="games", description="Gets current games for a league")
@app_commands.autocomplete(league=league_autocomplete)
async def games_command(interaction: discord.Interaction, league:str, ephemeral:bool = False):
	league = league.lower()
	if league not in data.leagues.keys():
		await interaction.response.send_message("The league doesn't exist.")
	else:
		await interaction.response.defer(ephemeral=ephemeral)
		games = get_league_games_tasked(data.leagues[league])
		if games is None or len(games) == 0:
			await interaction.followup.send(content="No games!", ephemeral=ephemeral)
		else:
			embeds = []
			for game in games:
				embeds.append(game.generate_embed())
			if embeds is None:
				await interaction.followup.send(content="says there were games but couldn't make an embed.\n go bother bee /shrug", ephemeral=ephemeral)
			else:
				await interaction.followup.send(content=f"Day {mmolbee.time.season_day}",embeds=embeds, ephemeral=ephemeral)


@mmolbee.tree.command(name="save", description="Saves league stats. I'll automate this sometime.")
async def save_command(interaction: discord.Interaction):
	await interaction.response.defer()
	teams = []
	if mmolbee.time.season_day is None or mmolbee.time.season_number is None:
		await interaction.followup.send(content="Time does not seem to exist.")
		return
	for league in data.leagues.values():
		print("Getting stats for: " + league.name)
		for team in league.teams.values():
			team.savefile(mmolbee.time)
			teams.append(team)
	await interaction.followup.send(content=f"Saved stats for {teams}.")

@mmolbee.tree.command(name="lottery", description="let's go GAMBLING")
async def lottery_command(interaction: discord.Interaction):
	numbers = f"Lottery Numbers: {random.randint(0,9)} {random.randint(0,9)} {random.randint(0,9)}"
	embed = discord.Embed(title=numbers,color=discord.Color.red())
	embed.set_footer(text="GAMBLING")
	await interaction.response.send_message(embed=embed,ephemeral=True)

@mmolbee.tree.command(name="tracker_restart", description="Restarts the weather tracker. Note: will post in the channel this is used.")
@app_commands.autocomplete(league=league_autocomplete)
async def tracker_restart_command(interaction: discord.Interaction, league:str):
	league = league.lower()
	if league not in data.leagues.keys():
		await interaction.response.send_message("The league doesn't exist.")
	else:
		await interaction.response.defer()
		watched = []
		games = get_league_games_tasked(data.leagues[league])
		for game in games:
			watched.append(game.game_id)
		bkgrd_tasks = set()
		await interaction.followup.send(content=f"Watching the following games: {', '.join(watched)}")
		delay = 0
		for i in watched:
			task = asyncio.create_task(corruption.wither_tracker(i, interaction.channel, delay*5))
			bkgrd_tasks.add(task)
			task.add_done_callback(bkgrd_tasks.discard)
			delay += 1
		await asyncio.gather(*bkgrd_tasks)


@mmolbee.tree.command(name="shutdown", description="Turns off the bot. Please don't do this unless you need to.")
async def shutdown_command(interaction: discord.Interaction):
	await interaction.response.send_message("baba booey")
	exit()

async def palette_autocomplete(
	interaction: discord.Interaction,
	current: str,
) -> list[app_commands.Choice[str]]:
	palettes = 	["Unedited", "Contrast", "High_Contrast"]
	return [app_commands.Choice(name=palette, value=palette)
		for palette in palettes if current.lower() in palette.lower()]

@mmolbee.tree.command(name="recap", description="Generates a recap of the given game!")
@app_commands.autocomplete(palette=palette_autocomplete)
async def recap_command(interaction: discord.Interaction, game_id:str, palette:str = "Contrast", ephemeral:bool = False):
	if "watch/" in game_id:
		idx = game_id.index("watch/") + 6
		game_id = game_id[idx:].replace("/","")
	ft = flavor.holder.get_flavor()
	gwp = GameWinPercent(game_id)
	if not gwp.ready:
		await interaction.response.send_message(embed=gwp.no_dice(), ephemeral=ephemeral)
		return
	flavor_embed = ft.generate_embed(game_id)
	await interaction.response.send_message(embed=flavor_embed, ephemeral=ephemeral)
	slp_time = (random.randint(0,100)/33) + 5
	chart = asyncio.create_task(async_build_embed(gwp, palette))
	slp = asyncio.sleep(slp_time)
	files = await asyncio.gather(chart, slp)
	img = files[0][0]
	embeds = files[0][1]
	embeds[0].set_footer(text=flavor_embed.footer.text)
	#await asyncio.gather(interaction.delete_original_response(), chan.send(file=discord.File(files[0][0], "cool.png"), embeds=files[0][1]))
	await interaction.edit_original_response(attachments=[discord.File(img, "cool.png")],embeds=embeds)

async def async_build_embed(gwp: GameWinPercent, palette):
	img = gwp.generate_chart(Palette(palette.upper()))
	embs = gwp.generate_embeds()
	return img, embs


@mmolbee.tree.command(name="test", description="it is a mystery command")
async def test_command(interaction: discord.Interaction):
	#wither
	#game_id = "690f857e0d411ebcb8db42eb"
	#ejected
	#game_id = "694d438ff0572d97104daaeb"
	#party
	#game_id = "69488a2f8a3ecb19eb370715"
	#efflo
	#await game_id="694d97f4f0572d97104daffa"
	#await corruption.wither_tracker(game_id, interaction.channel, 0)
	await interaction.response.defer()
	mmolbee.kround = kumite_rounding(mmolbee.time.season_day)
	# kr1 = kumite_rounding(242) #round 1
	# kr2 = kumite_rounding(244) #round 2
	# kr3 = kumite_rounding(246) #round 3
	# content = (f"242: Round of {kr1[0]}, {kr1[1]} teams left, {kr1[2]} games to go!\n"
	# 		   f"244: Round of {kr2[0]}, {kr2[1]} teams left, {kr2[2]} games to go!\n"
	# 		   f"246: Round of {kr3[0]}, {kr3[1]} teams left, {kr3[2]} games to go!")
	leagues2 = []
	leagues = data.leagues.values()
	accept = ["Clover", "Banana"]
	for league in leagues:
		if league.name in accept:
			leagues2.append(league)
	await post_postseason_games(leagues2, interaction.client)
	await interaction.followup.send("egg")
	#await check_games_tasks(interaction.client)

	#await season_weather(interaction.client)
#start of tasks
@tasks.loop(time=times.times)
async def check_games_tasks(client: discord.Client):
	newday = data.SeasonTime()
	print(f"API Day: {newday}\nMMOLBee Day: {mmolbee.time}")
	if newday == mmolbee.time:
		print("Days are the same... timeloop?")
		return None
	#also updates day lol
	print(f"Updating day... Currently: {mmolbee.time}")
	mmolbee.time.update_time()
	print(f"Now: {mmolbee.time}")
	#kumite? please?
	bkgrd_tasks = set()
	if "postseason" in mmolbee.time.season_status.lower():
		mmolbee.kround = kumite_rounding(mmolbee.time.season_day)
		task = asyncio.create_task(post_postseason_games(data.leagues.values(), client))
		bkgrd_tasks.add(task)
		task.add_done_callback(bkgrd_tasks.discard)
		await asyncio.gather(*bkgrd_tasks)
	#actual games handling
	else:
		for league in data.leagues.values():
			if league.channel is not None:
				task = asyncio.create_task(post_league_game_embeds_task(league, client, mmolbee.time))
				bkgrd_tasks.add(task)
				task.add_done_callback(bkgrd_tasks.discard)
		await asyncio.gather(*bkgrd_tasks)

@tasks.loop(time=times.ten)
async def season_weather(client: discord.Client):
	newday = data.SeasonTime()
	days = [1, 121]
	if newday.season_day in days:
		fo = data.Forecast()
		embed = fo.generate_embed()
		for league in data.leagues.values():
			if league.channel is not None:
				channel = await client.fetch_channel(league.channel)
				await channel.send(embed=embed)

@tasks.loop(time=times.quad)
async def post_stats(client: discord.Client):
	stat = random.choice(list(stats.Statistics.keys()))
	#consider making this a range
	if random.randint(0,3) == 0:
		players = []
		for league in data.leagues.values():
			for team in league.teams.values():
				players += team.players
		statlist = stats.Statistics[stat].calc_leaderboard(players)
		embed = generate_stat_embed(statlist, f"🐝 MMOL-Bee", stats.Statistics[stat].name)
		for league in data.leagues.values():
			chan = await client.fetch_channel(league.channel)
			await chan.send(embed=embed)
	#normal path
	else:
		for league in data.leagues.values():
			if league.channel is not None:
				players = []
				for team in league.teams.values():
					players += team.players
				statlist = stats.Statistics[stat].calc_leaderboard(players)
				embed = generate_stat_embed(statlist, f"{league.emoji} {league.name} League", stats.Statistics[stat].name)
				chan = await client.fetch_channel(league.channel)
				await chan.send(embed=embed)

@tasks.loop(time=times.fiftynine)
async def update_standings(client: discord.Client):
	for league in data.leagues.values():
		for team in league.teams.values():
			print(f"Updating {team.name}")
			team.update()
			print(f"{team.name} updated")

#async tasks

async def post_league_game_embeds_task(league, client, day):
	embeds = []
	watched = []
	count = 0
	games = get_league_games_tasked(league)
	print(league.name)
	while len(games) == 0 and count < 10:
		count += 1
		#no games, lets sleep
		print(f"Attempt {count}: No games found in {league.name}, sleeping.")
		await asyncio.sleep(30)
		print(f"{league.name} is now awake.")
		games = get_league_games_tasked(league)
	if len(games) == 0:
		print(f"No games found in {league.name}.")
	else:
		showdowns = 0
		for game in games:
			if game.showdown:
				showdowns += 1
		print(f"Found {len(games)} games ({showdowns} showdowns) of {len(league.teams)} in {league.name}.")
		# just in case a team got missed - run it again and confirm
		if (len(games) + showdowns) < len(league.teams):
			print(f"Checking {league.name} again.")
			altgames = get_league_games_tasked(league)
			if len(altgames) > len(games):
				games = altgames
		spotlight_json = data.MMOLBApiary.get_spotlight_game_json()
		spotlight = None
		if 'game_id' in spotlight_json:
			spotlight = spotlight_json['game_id']
		for game in games:
			if game.game_id == spotlight:
				game.spotlight = True
			embeds.append(game.generate_embed())
			watched.append(game.game_id)
	if len(embeds) > 0:
		print(f"sending {league.name}")
		#should always exist, but lets be careful
		chan = await client.fetch_channel(league.channel)
		# if "postseason" in mmolbee.time.season_status.lower():
		# 	# round. teams. games.
		# 	if mmolbee.kround[0] != mmolbee.kround[1]:
		# 		content = f"Round of {mmolbee.kround[0]}? ({mmolbee.kround[2]} games to go... maybe)"
		# 	else:
		# 		content = f"Round of {mmolbee.kround[0]} ({mmolbee.kround[2]} games to go!)"
		# 	msg  = await chan.send(content=content, embeds=embeds)
		# else:
			#msg = await chan.send(content=f"{league.emoji} {league.name} Day {day.season_day}", embeds=embeds)
		msg = await chan.send(content=f"{league.emoji} {league.name} Day {day.season_day}", embeds=embeds)
		print(f"{league.name} sent")
		if len(watched) > 0:
			thr = await msg.create_thread(name=f"Day {day.season_day}", auto_archive_duration=60)
			#this is for Weather
			print(f"{league.name} Weather checks: {watched}")
			bkgrd_tasks = set()
			delay = 0
			for i in watched:
				task = asyncio.create_task(corruption.wither_tracker(i, thr, delay*5))
				bkgrd_tasks.add(task)
				task.add_done_callback(bkgrd_tasks.discard)
				delay += 1
			await asyncio.gather(*bkgrd_tasks)

async def post_postseason_games(leagues: list[data.SubLeague], client):
	games = []
	embeds = []
	watched = []
	messages = []
	spotlight_json = data.MMOLBApiary.get_spotlight_game_json()
	spotlight = None
	if 'game_id' in spotlight_json:
		spotlight = spotlight_json['game_id']
	for league in leagues:
		if league.name == "Clover":
			continue
		games.extend(get_league_games_tasked(league))
		#games.append(get_league_games_tasked(league))
	if len(games) > 0:
		print(games)
		for game in games:
			if game.game_id == spotlight:
				game.spotlight = True
			embeds.append(game.generate_embed())
			watched.append(game.game_id)
	else:
		print("No kumite games found... I hope that's right!")
	if len(embeds) > 0:
		if mmolbee.kround[0] != mmolbee.kround[1]:
			content = f"Round of {mmolbee.kround[0]}? ({mmolbee.kround[2]} games to go... maybe)"
		else:
			content = f"Round of {mmolbee.kround[0]} ({mmolbee.kround[2]} games to go!)"
		print(f"posting postseason. postly.")
		for league in leagues:
			if league.name == "Clover":
				continue
			chan = await client.fetch_channel(league.channel)
			msg = await chan.send(content=content, embeds=embeds)
			messages.append(msg)
			print(f"{league.name} postseason sent")
		if len(watched) > 0:
			bkgrd_tasks = set()
			for msg in messages:
				thr = await msg.create_thread(name=f"Day {mmolbee.time.season_day}", auto_archive_duration=60)
				delay = 0
				for i in watched:
					task = asyncio.create_task(corruption.wither_tracker(i, thr, delay * 5))
					bkgrd_tasks.add(task)
					task.add_done_callback(bkgrd_tasks.discard)
					delay += 1
			await asyncio.gather(*bkgrd_tasks)

def get_league_games_tasked(league):
	games = []
	id_set = set()
	teams = sorted(league.teams.values(), key=lambda tm: (tm.winpct(), tm.rundiff()), reverse=True)
	for team in teams:
		game_id = get_game_id(team)
		if game_id is None:
			continue
		if game_id in id_set:
			found = False
			for game in games:
				if game.game_id == game_id:
					game.showdown = True
					found = True
					break
			if found:
				continue
			else:
				print("uhhh shouldn't get here. oh no")
				continue
		else:
			id_set.add(game_id)
		game = get_game(game_id, team.color)
		if game is None:
			continue
		game.leaguestr = str(league)
		games.append(game)
	return games



def generate_stat_embed(statlist, leaguename, statname):
	field1 = ""
	field2 = ""
	field3 = ""
	field4 = ""
	title = f"{leaguename}"
	for i in statlist[:5]:
		field1 += f"{i['emoji']} [{i['name']}](https://mmolb.com/player/{i['id']})\n"
		field2 += f"{i['display']}<:nothing:1407773446540099704>\n"
	for i in statlist[-3:]:
		field3 += f"{i['emoji']} [{i['name']}](https://mmolb.com/player/{i['id']})\n"
		field4 += f"{i['display']}<:nothing:1407773446540099704>\n"
	embed = discord.Embed(color=discord.Color.purple(), title=title)
	embed.add_field(name=f"{statname} Leaders:", value="", inline=False)
	embed.add_field(name="", value=field1, inline=True)
	embed.add_field(name="", value=field2, inline=True)
	#embed.add_field(name="Needs Improvement:", value="", inline=False)
	#embed.add_field(name="", value=field3, inline=True)
	#embed.add_field(name="", value=field4, inline=True)
	embed.set_footer(text="One day, Statcat will wake up...", icon_url="https://images.swarm.computer/mmolbee/blobcathappy.png")
	return embed

#helper stuff

def kumite_rounding(day: int) -> tuple[int,int,int]|None:
	games_json = data.MMOLBApiary.get_games_for_day(day)
	if games_json is None:
		return None
	count = len(games_json['games'])
	teams = count * 2
	print(f"{count} games found. {teams} teams.")
	# 2^length of the bit
	round = (1 if teams == 0 else 2**(teams-1).bit_length())
	#mult by 2 to get total number of teams :)
	games_left = data.POWERS_OF_2.index(round)
	print(f"{games_left} games left. i think?")
	#bracket round, teams competing, games left
	return round, teams, games_left

def get_game_id(team) -> str | None:
	currgame = data.MMOLBApiary.get_live_game_json_by_team(team)
	if currgame is not None:
		if 'error' in currgame:
			# no games!
			return None
		else:
			return currgame['game_id']
	print("error finding the game, yo")
	return None

def get_game(id: str, color: str) -> Game | None:
	game_json = data.MMOLBApiary.get_game_json(id)
	if game_json is None:
		return None
	game = data.Game(id,
					 f'{game_json["AwayTeamEmoji"]} {game_json["AwayTeamName"]}',
					 game_json["AwayTeamID"],
					 game_json["AwaySP"],
					 f'{game_json["HomeTeamEmoji"]} {game_json["HomeTeamName"]}',
					 game_json["HomeTeamID"],
					 game_json["HomeSP"],
					 game_json["Weather"],
					 color,
					 game_json["HomeTeamColor"])
	return game

mmolbee.run(TOKEN)
