from discord._types import ClientT
from emoji import purely_emoji

import data
import emoji

import discord
from discord import ui, Interaction


# adds a league! waow
class NewLeagueModal(ui.Modal, title="New League"):
	name = discord.ui.TextInput(
		label='Name',
		placeholder='League Name'
	)
	emoji = discord.ui.TextInput(
		label='Emoji',
		placeholder="idk why you're making this girl you're the only one who is gonna use it",
	)

	async def interaction_check(self, interaction: Interaction, /) -> bool:
		return emoji.purely_emoji(self.emoji.value) and self.name.value not in data.leagues.keys()

	async def on_submit(self, interaction: discord.Interaction):
		data.add_subleague(self.name.value, self.emoji.value, interaction.channel.id)
		await interaction.response.send_message(f'{self.emoji} {self.name} League has been added.')

	async def on_error(self, interaction: Interaction[ClientT], error: Exception, /) -> None:
		print(error)
		await interaction.response.send_message(
			"Stop! You violated the law. Pay the court a fine or serve your sentence. Your ｍａｌｆｏｒｍｅｄ　ｄａｔａ are now forfeit.")

#adds a team! waow
class NewTeamModal(ui.Modal, title="New Team"):
    def __init__(self, sub_league):
        self.team_obj = None
        self.sub_league_name = sub_league.lower()
        super().__init__()
    team_id = discord.ui.TextInput(
        label='Team ID',
        placeholder='mmolb.com/team/<this thing>'
    )
    async def interaction_check(self, interaction: discord.Interaction) -> bool:
        self.team_obj = data.MMOLBApiary.get_team_obj(self.team_id.value)
        return bool(self.team_obj) and bool(self.sub_league_name)

    async def on_submit(self, interaction: discord.Interaction):
        sub_league = data.leagues[self.sub_league_name]
        sub_league.add_team(self.team_obj)
        await interaction.response.send_message(f"{self.team_obj} added to {self.sub_league_name}")