import random

import discord

GEBLOBCAT = "<a:geblobcat:1439000190974427166>"
ARTIST="<:blobcatartist:1439021933445255338>"
CAR = "<a:ablobcatcar:1439007383736025148>"
FLUSTERED = "<:blobcatflustered:1439004889631031488>"
FIRE_EYES = "<:blobcatfireeyes:1439004811621306400>"
FEAR = "<:blobcatfear:1439004810442706995>"
HAPPY = "<:blobcathappy:1439039263432900719>"
HAPPY_REV = "<:blobcathappyr:1439023316064145508>"
HERO = "<:blobcathero:1439026876000637019>"
OFTON = "<:blobcatofton:1439007385300631582>"
SLEEP = "<:blobcatsleep:1439017271367307274>"
SMALLFACE = "<:blobcatsmallface:1439010157940965417>"
THINK = "<:blobcatthink:1439029977872990329>"
THINK_REV = "<:blobcatthink_rev:1439029976924946642>"
WATCHING = "<:blobcatwatching:1439007386630230178>"

NOTHING = "<:nothing:1407773446540099704>"


class FlavorText:
	footer_list = ["Corndogs", "Groundskeeping", "Concessions", "Phlebotomy", "Astronomy", "Laundry", "Eggrolls", "Bat Procurement",
				   "Lesser League Relations", "Haunted Arcades", "Wet Pretzels", "Popcorn", "Scarabs", "Item Wiggling",
				   "Chunching", "Statcat Union Relations", "Strikes (looking)", "Strikes (swinging)", "Strikes (labor dispute)",
				   "Chasing Down Foul Balls", "Sundaes", "Weather Forecasting", "Corruption Management", "Lawncare",
				   "Gardening", "Territory Management", "Advertising", "Sports", "Shorts", "Storms", "Rabbits", "Pigeons",
				   "Liars", "Sticks", "Magpies", "Some Sort of Yellow Thing", "Remedial Stats", "Bugs", "Snack Research", "Treat Development",
				   "Those Ice Creams Served In The Tiny Helmets", "Public Relations", "Public Enemies", "Taxes", "Accounting",
				   "inf", "Twin Drills", "Flavor Text", "Grass", "Foul Poles", "Bases", "Balls", "Dugout Maintenance",
				   "Ticket Sales", "Pitch Speed Tracking", "Gloves", "Bats", "Flowers", "Weather Forecasting", "Shuffling",
				   "Peanuts", "Cracker Jack (But Not The Brand)", "Hot Dogs", "Sunflower Seeds", "Tarps", "Water Management",
				   "Turning The Lights On and Off", "Scoreboard Management", "Departments", "Team Naming", "Synthetics",
				   "Eephus..es", "Fastballs", "Curveballs", "Sliders", "Splitters", "Knurving All Over The Place", "Changeups",
				   "Sweepers", "French Fries", "Candy", "Modems", "History", "Wizards", "Tomes", "Talismans", "Hats", "Gambling",
				   "Baseball", "Commissioners", "Hidden Palettes", "Playcoins", "Wins", "Losses", "Chicken Sandwiches",
				   "Bratwurst", "Sauerkraut", "Keychains", "Phone Charms", "Corvids", "Public Transportation", "Curios",
				   "Knockoff Merchandise", "Merchandise", "Licensing", "Printing Out Scorecards", "Voting", "Baserunning",
				   "Defense", "Batting", "Pitching", "Luck", "Double Plays", "Maximum Baseball", "Minimum Baseball",
				   "Consumers", "MMOLBee 2", "Time Loops", "Gardening", "Ironing", "Statcats", "Golden Pitches", "Thinking of Funny Stats",
				   "Walks", "Balks", "Foul Tips", "Foul Balls", "Infield Singles", "Scoring from First", "Home Runs", "Complete Games",
				   "Shutouts", "oo ee oo", "Photography", "Videography", "Paintings", "Berries", "Smoothies", "🚶‍♂️", "Immaculate Innings",
				   "Missile Locks", "Hazards", "Roses", "Emoji", "Surgery", "My Friend Kaito", "Grgin' It", "Rosaries",
				   "Reverie", "Revelry", "Chalk", ":blobokball:", ]
	def __init__(self, title: str, title_emoji: str = GEBLOBCAT, description: str = NOTHING):
		self.title = title
		self.title_emoji = title_emoji
		self.description = description

	def generate_embed(self, game_id:str) -> discord.Embed:
		embed = discord.Embed(title=f"**{self.title}** {self.title_emoji}",
							  description=f"{self.description}\n{NOTHING}\ngame: {game_id}",
							  color=discord.Color.dark_purple())
		embed.set_footer(text=f"Department of Advanced Stats, {random.choice(self.footer_list)}, and {random.choice(self.footer_list)}")
		return embed

class FlavorHolder:
	flavor_base = [
		FlavorText("Chunching data..."),
		FlavorText("vote? wimdy..."),
		FlavorText("Getting banned from the API..."),
		FlavorText("Herding Statcats..."),
		FlavorText("Getting out the nice posterboard..."),
		FlavorText("Opening the scary supply closet in the basement...", FEAR),
		FlavorText("Collecting all the foul balls..."),
		FlavorText("Making the players redo the game..."),
		FlavorText("Strike, Looking..."),
		FlavorText("Thomas Dracaena hit a ground out to Edric Tosser."),
		FlavorText("Watering the roses..."),
		FlavorText("Replacing the toner..."),
		FlavorText("Buying new markers..."),
		FlavorText("Coming up with team names..."),
		FlavorText("Waiting for the next framerule...", CAR),
		FlavorText("Watching.", WATCHING),
		FlavorText("Wiggling items..."),
		FlavorText("Pitching to Zone 10...", FLUSTERED),
		FlavorText("Waiting for the oven to heat up..."),
		FlavorText("Salting the pretzels..."),
		FlavorText("Getting out the color swatches..."),
		FlavorText("Getting express written consent from the commissioner..."),
		FlavorText("Reticulating splines..."),
		FlavorText("Oh. Um. This one's not done yet. Can you come back.", SMALLFACE),
		FlavorText("Getting excited for a moment..."),
		FlavorText("Developing new snacks..."),
		FlavorText("Interviewing the 🚶‍♂️..."),
		FlavorText("Brewing more coffee..."),
		FlavorText("Looking for the hidden color palettes..."),
		# hmmm
		FlavorText("Putting the record on..."),
		FlavorText("It's not a toyota...", CAR),
		FlavorText("Finding the point where the two paths meet..."),
		FlavorText("It's a ruby colored ~~wednesday~~ tuesday...", FIRE_EYES),
		FlavorText("Skipping the formalities..."),
		FlavorText("Twisting the kaleidoscope..."),
		FlavorText("Breaking through the radio..."),
	]
	flavor_synth_base = [
		FlavorText("oo ee oo"),
		FlavorText("oo ee oo"),
		FlavorText("oo ee oo"),
		FlavorText("oo ee oo"),
		FlavorText("oo ee oo"),
		FlavorText("oo ee oo")
	]
	flavor = []
	flavor_synth = []

	def __init__(self):
		self.flavor = self.flavor_base.copy()
		self.flavor_synth = self.flavor_synth_base.copy()
		random.shuffle(self.flavor)
		random.shuffle(self.flavor_synth)


	def get_flavor(self):
		out = None
		if random.randint(0, 3) == 0:
			if len(self.flavor_synth) < (len(self.flavor_synth_base) / 3):
				print("fresh synth")
				self.flavor_synth = self.flavor_synth_base.copy()
				random.shuffle(self.flavor_synth)
				print(len(self.flavor_synth))
			out = self.flavor_synth.pop()
		else:
			if len(self.flavor) < (len(self.flavor_base) / 3):
				print("fresh normal")
				self.flavor = self.flavor_base.copy()
				random.shuffle(self.flavor)
				print(len(self.flavor))
			out = self.flavor.pop()
		return out


holder = FlavorHolder()


if __name__ == '__main__':
	print(len(holder.flavor_synth), len(holder.flavor))
	for i in range(300):
		holder.get_flavor()
	print(len(holder.flavor_synth), len(holder.flavor))
